<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>پیام‌رسان آرمسیج</title>
    <link rel="stylesheet" href="style.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
</head>
<body>
    <?php require 'config.php'; ?>

    <?php if (!isset($_SESSION['user_id'])): ?>
        <!-- صفحه لاگین -->
        <div class="login-container">
            <div class="login-box">
                <h1>ورود به آرمسیج</h1>
                <p>برای استفاده از امکانات لطفا وارد شوید</p>
                <a href="auth.php?login=1" class="sso-btn">ورود امن با آرمسیج</a>
            </div>
        </div>
    <?php else: ?>
        <!-- محیط چت -->
        <div class="app-container">
            <!-- سایدبار -->
            <div class="sidebar">
                <div class="my-profile">
                    <img src="uploads/default.png" id="myAvatar" alt="Profile">
                    <span id="myName">کاربر</span>
                    <button onclick="openSettings()"><i class="fas fa-cog"></i></button>
                    <a href="auth.php?logout=1" title="خروج"><i class="fas fa-sign-out-alt"></i></a>
                </div>
                
                <div class="search-box">
                    <input type="text" id="searchInput" placeholder="جستجو (شماره/نام کاربری)...">
                    <button onclick="searchUser()"><i class="fas fa-search"></i></button>
                </div>
                
                <div class="conversations-list" id="conversationsList">
                    <!-- لیست چت‌ها اینجا لود می‌شود -->
                </div>
            </div>

            <!-- صفحه چت اصلی -->
            <div class="chat-area" id="chatArea">
                <div class="chat-header" id="chatHeader" style="display:none;">
                    <div class="user-info">
                        <img src="" id="headerAvatar">
                        <div class="details">
                            <h3 id="headerName"></h3>
                            <span id="headerStatus"></span>
                        </div>
                    </div>
                </div>

                <div class="messages-container" id="messagesContainer">
                    <div class="placeholder-text">یک گفتگو را انتخاب کنید یا جستجو کنید</div>
                </div>

                <div class="input-area" id="inputArea" style="display:none;">
                    <div id="replyPreview" class="reply-preview" style="display:none;">
                        <span>در پاسخ به: </span>
                        <span id="replyText"></span>
                        <button onclick="cancelReply()">✕</button>
                    </div>
                    
                    <form id="msgForm" onsubmit="sendMessage(event)">
                        <input type="hidden" id="targetId">
                        <input type="hidden" id="isGroup" value="0">
                        <input type="hidden" id="targetPhone">
                        <input type="hidden" id="replyToId">
                        
                        <button type="button" class="attach-btn" onclick="document.getElementById('fileInput').click()">
                            <i class="fas fa-paperclip"></i>
                        </button>
                        <input type="file" id="fileInput" hidden onchange="previewFile()">
                        
                        <input type="text" id="msgInput" placeholder="پیام خود را بنویسید..." autocomplete="off">
                        
                        <button type="button" id="voiceBtn" onmousedown="startRecording()" onmouseup="stopRecording()">
                            <i class="fas fa-microphone"></i>
                        </button>
                        
                        <button type="submit" class="send-btn"><i class="fas fa-paper-plane"></i></button>
                    </form>
                </div>
            </div>
        </div>

        <!-- مودال تنظیمات -->
        <div id="settingsModal" class="modal">
            <div class="modal-content">
                <span class="close" onclick="closeSettings()">&times;</span>
                <h2>تنظیمات پروفایل</h2>
                <form id="settingsForm" onsubmit="updateProfile(event)">
                    <input type="text" name="first_name" placeholder="نام" required>
                    <input type="text" name="last_name" placeholder="نام خانوادگی" required>
                    <input type="text" name="username" placeholder="نام کاربری">
                    <label>تغییر عکس پروفایل:</label>
                    <input type="file" name="avatar">
                    <button type="submit">ذخیره تغییرات</button>
                </form>
            </div>
        </div>
    <?php endif; ?>

    <script src="app.js"></script>
</body>
</html>
