<?php
require 'config.php';

// اگر کد برگشتی وجود دارد (مرحله ۲ و ۳ مستندات)
if (isset($_GET['code'])) {
    $code = $_GET['code'];
    
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, SSO_URL . "/auth/index.php");
    curl_setopt($ch, CURLOPT_POST, 1);
    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
        'code' => $code,
        'client_id' => CLIENT_ID,
        'client_secret' => CLIENT_SECRET
    ]));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $response = curl_exec($ch);
    curl_close($ch);
    
    $result = json_decode($response, true);
    
    if (isset($result['success']) && $result['success'] === true) {
        $userData = $result['user'];
        
        // بررسی وجود کاربر در دیتابیس یا ثبت نام جدید
        $stmt = $pdo->prepare("SELECT * FROM users WHERE phone = ?");
        $stmt->execute([$userData['phone']]);
        $user = $stmt->fetch();
        
        if (!$user) {
            // ثبت نام کاربر جدید
            $stmt = $pdo->prepare("INSERT INTO users (sso_id, phone, first_name, last_name) VALUES (?, ?, ?, ?)");
            $stmt->execute([$userData['id'], $userData['phone'], $userData['first_name'], $userData['last_name']]);
            $userId = $pdo->lastInsertId();
            
            // **مهم:** اتصال پیام‌هایی که قبلا به شماره این کاربر ارسال شده بود
            $updateMsg = $pdo->prepare("UPDATE messages SET receiver_id = ? WHERE receiver_phone = ? AND receiver_id IS NULL");
            $updateMsg->execute([$userId, $userData['phone']]);
            
        } else {
            $userId = $user['id'];
            // بروزرسانی اطلاعات اگر تغییر کرده باشد
             $stmt = $pdo->prepare("UPDATE users SET first_name = ?, last_name = ? WHERE id = ?");
             $stmt->execute([$userData['first_name'], $userData['last_name'], $userId]);
        }
        
        $_SESSION['user_id'] = $userId;
        $_SESSION['phone'] = $userData['phone'];
        
        header("Location: index.php");
        exit;
    } else {
        die("خطا در ورود به آرمسیج: " . ($result['error'] ?? 'ناشناخته'));
    }
}

// اگر درخواست لاگین است (مرحله ۱)
if (isset($_GET['login'])) {
    $url = SSO_URL . "/login/?client_id=" . CLIENT_ID . "&redirect_uri=" . urlencode(REDIRECT_URI);
    header("Location: $url");
    exit;
}

// خروج
if (isset($_GET['logout'])) {
    session_destroy();
    header("Location: index.php");
}
?>
