let currentChatId = null;
let currentIsGroup = 0;
let mediaRecorder;
let audioChunks = [];

// بارگذاری اولیه
document.addEventListener('DOMContentLoaded', () => {
    loadConversations();
    setInterval(() => {
        if (currentChatId) loadMessages(currentChatId, currentIsGroup, false); // آپدیت چت باز
        loadConversations(); // آپدیت لیست چت‌ها برای پیام جدید
    }, 3000); // هر 3 ثانیه رفرش (Long Polling ساده)
});

function loadConversations() {
    fetch('api.php?action=get_conversations')
    .then(r => r.json())
    .then(data => {
        const list = document.getElementById('conversationsList');
        list.innerHTML = '';
        
        data.users.forEach(u => {
            list.innerHTML += `
                <div class="convo-item" onclick="openChat(${u.id}, 0, '${u.phone}', '${u.first_name} ${u.last_name}', '${u.avatar || 'default.png'}')">
                    <img src="uploads/${u.avatar || 'default.png'}">
                    <div>
                        <b>${u.first_name} ${u.last_name}</b>
                        <div style="font-size:12px; color:grey;">${u.phone}</div>
                    </div>
                </div>`;
        });
        // رندر گروه‌ها هم اینجا اضافه می‌شود
    });
}

function searchUser() {
    const query = document.getElementById('searchInput').value;
    fetch('api.php', {
        method: 'POST',
        headers: {'Content-Type': 'application/x-www-form-urlencoded'},
        body: `action=search_user&query=${query}`
    })
    .then(r => r.json())
    .then(data => {
        const list = document.getElementById('conversationsList');
        list.innerHTML = '<h4>نتایج جستجو:</h4>';
        
        if (data.results.length > 0) {
            data.results.forEach(u => {
                list.innerHTML += `
                    <div class="convo-item" onclick="openChat(${u.id}, 0, '${u.phone}', '${u.first_name} ${u.last_name}', '${u.avatar || 'default.png'}')">
                        <img src="uploads/${u.avatar || 'default.png'}">
                        <span>${u.first_name} ${u.last_name}</span>
                    </div>`;
            });
        } else {
            // اگر کاربر پیدا نشد، امکان ارسال پیام به شماره را می‌دهیم (آفلاین مسیج)
            if(!isNaN(query) && query.length > 9) {
                list.innerHTML += `
                <div class="convo-item" onclick="openChat(null, 0, '${query}', 'کاربر ناشناس', 'default.png')">
                    <img src="uploads/default.png">
                    <span>ارسال پیام به ${query}</span>
                </div>`;
            } else {
                list.innerHTML += '<p>کاربری یافت نشد.</p>';
            }
        }
    });
}

function openChat(id, isGroup, phone, name, avatar) {
    currentChatId = id;
    currentIsGroup = isGroup;
    
    document.getElementById('targetId').value = id || '';
    document.getElementById('targetPhone').value = phone;
    document.getElementById('isGroup').value = isGroup;
    document.getElementById('chatHeader').style.display = 'flex';
    document.getElementById('headerName').innerText = name;
    document.getElementById('headerAvatar').src = 'uploads/' + avatar;
    document.getElementById('inputArea').style.display = 'flex';
    
    loadMessages(id, isGroup, true);
}

function loadMessages(id, isGroup, scrollBottom) {
    if(!id && !document.getElementById('targetPhone').value) return; // اگر نه ایدی هست نه شماره

    let url = `api.php?action=get_messages&target_id=${id}&is_group=${isGroup}`;
results.forEach(u => {
                list.innerHTML += `
                    <div class="convo-item" onclick="openChat(${u.id}, 0, '${u.phone}', '${u.first_name} ${u.last_name}', '${u.avatar || 'default.png'}')">
                        <img src="uploads/${u.avatar || 'default.png'}">
                        <span>${u.first_name} ${u.last_name}</span>
                    </div>`;
            });
        } else {
            // اگر کاربر پیدا نشد، امکان ارسال پیام به شماره را می‌دهیم (آفلاین مسیج)
            if(!isNaN(query) && query.length > 9) {
                list.innerHTML += `
                <div class="convo-item" onclick="openChat(null, 0, '${query}', 'کاربر ناشناس', 'default.png')">
                    <img src="uploads/default.png">
                    <span>ارسال پیام به ${query}</span>
                </div>`;
            } else {
                list.innerHTML += '<p>کاربری یافت نشد.</p>';
            }
        }
    });
}

function openChat(id, isGroup, phone, name, avatar) {
    currentChatId = id;
    currentIsGroup = isGroup;
    
    document.getElementById('targetId').value = id || '';
    document.getElementById('targetPhone').value = phone;
    document.getElementById('isGroup').value = isGroup;
    document.getElementById('chatHeader').style.display = 'flex';
    document.getElementById('headerName').innerText = name;
    document.getElementById('headerAvatar').src = 'uploads/' + avatar;
    document.getElementById('inputArea').style.display = 'flex';
    
    loadMessages(id, isGroup, true);
}

function loadMessages(id, isGroup, scrollBottom) {
    if(!id && !document.getElementById('targetPhone').value) return; // اگر نه ایدی هست نه شماره

    let url = `api.php?action=get_messages&target_id=${id}&is_group=${isGroup}`;
    
    fetch(url)
    .then(r => r.json())
    .then(data => {
        const container = document.getElementById('messagesContainer');
        const myId = data.current_user_id;
        
        // فقط اگر محتوا تغییر کرده باشد رندر مجدد انجام میدهیم (ساده سازی شده: همیشه رندر)
        let html = '';
        data.messages.forEach(msg => {
            if(msg.is_deleted) return;

            let msgClass = msg.sender_id == myId ? 'sent' : 'received';
            let content = '';
            
            // نمایش ریپلای
            if(msg.reply_to_id) {
                content += `<div style="border-right: 2px solid #0088cc; padding-right:5px; margin-bottom:5px; font-size:12px; color:grey;">${msg.reply_content || 'پیام حذف شده'}</div>`;
            }

            if (msg.type === 'text') content += `<p>${msg.content}</p>`;
            else if (msg.type === 'image') content += `<img src="${msg.content}">`;
            else if (msg.type === 'voice') content += `<audio controls src="${msg.content}"></audio>`;
            else if (msg.type === 'video') content += `<video controls src="${msg.content}" width="200"></video>`;
            else content += `<a href="${msg.content}" download>دانلود فایل: ${msg.file_name}</a>`;
            
            // وضعیت تیک
            let ticks = '';
            if (msgClass === 'sent') {
                ticks = msg.is_read == 1 ? '<i class="fas fa-check-double tick"></i>' : '<i class="fas fa-check single-tick"></i>';
            }
            
            // دکمه‌ها (ویرایش/حذف/ریپلای)
            let actions = `<div class="msg-actions">
                <i class="fas fa-reply" onclick="replyTo(${msg.id}, '${msg.content}')"></i>`;
            if (msgClass === 'sent') {
                actions += ` <i class="fas fa-trash" onclick="deleteMsg(${msg.id})"></i>`;
                if(msg.type === 'text') actions += ` <i class="fas fa-edit" onclick="editMsg(${msg.id}, '${msg.content}')"></i>`;
            }
            actions += `</div>`;

            html += `<div class="message ${msgClass}">
                        ${content}
                        <div class="msg-meta">
                            <span>${msg.created_at.substr(11, 5)}</span>
                            ${ticks}
                        </div>
                        ${actions}
                     </div>`;
        });
        
        container.innerHTML = html;
        if(scrollBottom) container.scrollTop = container.scrollHeight;
    });
}

function sendMessage(e) {
    e.preventDefault();
    const formData = new FormData();
    formData.append('action', 'send_message');
    formData.append('receiver_id', document.getElementById('targetId').value);
    formData.append('receiver_phone', document.getElementById('targetPhone').value);
    formData.append('group_id', document.getElementById('isGroup').value);
    formData.append('content', document.getElementById('msgInput').value);
    formData.append('reply_to', document.getElementById('replyToId').value);
    
    const fileInput = document.getElementById('fileInput');
    if (fileInput.files.length > 0) {
        formData.append('file', fileInput.files[0]);
    }

    fetch('api.php', { method: 'POST', body: formData })
    .then(r => r.json())
    .then(data => {
        if(data.status === 'success') {
            document.getElementById('msgInput').value = '';
            document.getElementById('fileInput').value = '';
            cancelReply();
            loadMessages(currentChatId, currentIsGroup, true);
        } else {
            alert(data.message);
        }
    });
}

// توابع کمکی ریپلای
function replyTo(id, text) {
    document.getElementById('replyToId').value = id;
    document.getElementById('replyText').innerText = text.substring(0, 50) + '...';
    document.getElementById('replyPreview').style.display = 'block';
}
function cancelReply() {
    document.getElementById('replyToId').value = '';
    document.getElementById('replyPreview').style.display = 'none';
}

// حذف پیام
function deleteMsg(id) {
    if(confirm('آیا از حذف پیام مطمئن هستید؟')) {
        const formData = new FormData();
        formData.append('action', 'delete_message');
        formData.append('msg_id', id);
        fetch('api.php', { method: 'POST', body: formData }).then(() => loadMessages(currentChatId, currentIsGroup, false));
    }
}

// ضبط صدا (ساده)
function startRecording() {
    navigator.mediaDevices.getUserMedia({ audio: true }).then(stream => {
        mediaRecorder = new MediaRecorder(stream);
        mediaRecorder.start();
        audioChunks = [];
        mediaRecorder.addEventListener("dataavailable", event => {
            audioChunks.push(event.data);
        });
        document.getElementById('voiceBtn').style.color = 'red';
    });
}

function stopRecording() {
    if(mediaRecorder) {
        mediaRecorder.stop();
id, text) {
    document.getElementById('replyToId').value = id;
    document.getElementById('replyText').innerText = text.substring(0, 50) + '...';
    document.getElementById('replyPreview').style.display = 'block';
}
function cancelReply() {
    document.getElementById('replyToId').value = '';
    document.getElementById('replyPreview').style.display = 'none';
}

// حذف پیام
function deleteMsg(id) {
    if(confirm('آیا از حذف پیام مطمئن هستید؟')) {
        const formData = new FormData();
        formData.append('action', 'delete_message');
        formData.append('msg_id', id);
        fetch('api.php', { method: 'POST', body: formData }).then(() => loadMessages(currentChatId, currentIsGroup, false));
    }
}

// ضبط صدا (ساده)
function startRecording() {
    navigator.mediaDevices.getUserMedia({ audio: true }).then(stream => {
        mediaRecorder = new MediaRecorder(stream);
        mediaRecorder.start();
        audioChunks = [];
        mediaRecorder.addEventListener("dataavailable", event => {
            audioChunks.push(event.data);
        });
        document.getElementById('voiceBtn').style.color = 'red';
    });
}

function stopRecording() {
    if(mediaRecorder) {
        mediaRecorder.stop();
        mediaRecorder.addEventListener("stop", () => {
            const audioBlob = new Blob(audioChunks, { type: 'audio/mp3' });
            const formData = new FormData();
            formData.append('action', 'send_message');
            formData.append('receiver_id', document.getElementById('targetId').value);
            formData.append('receiver_phone', document.getElementById('targetPhone').value);
            formData.append('file', audioBlob, 'voice.mp3');
            
            fetch('api.php', { method: 'POST', body: formData }).then(() => loadMessages(currentChatId, currentIsGroup, true));
            document.getElementById('voiceBtn').style.color = 'inherit';
        });
    }
}

// تنظیمات و مودال
function openSettings() { document.getElementById('settingsModal').style.display = "block"; }
function closeSettings() { document.getElementById('settingsModal').style.display = "none"; }
function updateProfile(e) {
    e.preventDefault();
    const formData = new FormData(e.target);
    formData.append('action', 'update_profile');
    fetch('api.php', { method: 'POST', body: formData }).then(() => {
        alert('پروفایل بروز شد');
        location.reload();
    });
}
