<?php
require 'config.php';

header('Content-Type: application/json');

if (!isset($_SESSION['user_id'])) {
    echo json_encode(['status' => 'error', 'message' => 'Unauthorized']);
    exit;
}

$userId = $_SESSION['user_id'];
$action = $_POST['action'] ?? $_GET['action'] ?? '';

// ارسال پیام
if ($action == 'send_message') {
    $receiverId = $_POST['receiver_id'] ?? null; // ID کاربر گیرنده (اگر هست)
    $receiverPhone = $_POST['receiver_phone'] ?? null; // شماره گیرنده (برای جستجو یا ارسال به کاربر آفلاین)
    $groupId = $_POST['group_id'] ?? null;
    $content = $_POST['content'] ?? '';
    $replyTo = $_POST['reply_to'] ?? null;
    $type = 'text';
    $fileName = null;

    // آپلود فایل (عکس، فیلم، ویس)
    if (isset($_FILES['file']) && $_FILES['file']['error'] == 0) {
        $file = $_FILES['file'];
        $ext = pathinfo($file['name'], PATHINFO_EXTENSION);
        $allowed = ['jpg', 'jpeg', 'png', 'gif', 'mp4', 'mp3', 'wav', 'ogg', 'pdf', 'zip'];
        
        if ($file['size'] > 5 * 1024 * 1024) {
            echo json_encode(['status' => 'error', 'message' => 'حجم فایل بیشتر از 5 مگابایت است']);
            exit;
        }

        if (in_array(strtolower($ext), ['jpg', 'jpeg', 'png', 'gif'])) $type = 'image';
        elseif (in_array(strtolower($ext), ['mp4'])) $type = 'video';
        elseif (in_array(strtolower($ext), ['mp3', 'wav', 'ogg'])) $type = 'voice';
        else $type = 'file';

        $newName = uniqid() . '.' . $ext;
        move_uploaded_file($file['tmp_name'], 'uploads/' . $newName);
        $content = 'uploads/' . $newName;
        $fileName = $file['name'];
    }

    // منطق پیدا کردن receiver_id از روی شماره تلفن
    if (!$groupId && $receiverPhone && !$receiverId) {
        $stmt = $pdo->prepare("SELECT id FROM users WHERE phone = ?");
        $stmt->execute([$receiverPhone]);
        $foundUser = $stmt->fetch();
        if ($foundUser) {
            $receiverId = $foundUser['id'];
        }
    }

    $stmt = $pdo->prepare("INSERT INTO messages (sender_id, receiver_id, receiver_phone, group_id, content, type, file_name, reply_to_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$userId, $receiverId, $receiverPhone, $groupId, $content, $type, $fileName, $replyTo]);
    
    echo json_encode(['status' => 'success']);
}

// دریافت لیست چت‌ها (آخرین پیام‌ها)
if ($action == 'get_conversations') {
    // کوئری پیچیده برای گرفتن آخرین پیام هر چت (ساده شده)
    // در اینجا ما لیست کاربرانی که با آنها چت داریم را برمی‌گردانیم
    $stmt = $pdo->prepare("
        SELECT DISTINCT u.id, u.first_name, u.last_name, u.avatar, u.phone
        FROM users u
        JOIN messages m ON (m.sender_id = u.        }
    }

    $stmt = $pdo->prepare("INSERT INTO messages (sender_id, receiver_id, receiver_phone, group_id, content, type, file_name, reply_to_id) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
    $stmt->execute([$userId, $receiverId, $receiverPhone, $groupId, $content, $type, $fileName, $replyTo]);
    
    echo json_encode(['status' => 'success']);
}

// دریافت لیست چت‌ها (آخرین پیام‌ها)
if ($action == 'get_conversations') {
    // کوئری پیچیده برای گرفتن آخرین پیام هر چت (ساده شده)
    // در اینجا ما لیست کاربرانی که با آنها چت داریم را برمی‌گردانیم
    $stmt = $pdo->prepare("
        SELECT DISTINCT u.id, u.first_name, u.last_name, u.avatar, u.phone
        FROM users u
        JOIN messages m ON (m.sender_id = u.id AND m.receiver_id = ?) OR (m.receiver_id = u.id AND m.sender_id = ?)
        WHERE u.id != ?
    ");
    $stmt->execute([$userId, $userId, $userId]);
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // گروه‌ها
    $stmtGrp = $pdo->prepare("SELECT g.* FROM chat_groups g JOIN group_members gm ON g.id = gm.group_id WHERE gm.user_id = ?");
    $stmtGrp->execute([$userId]);
    $groups = $stmtGrp->fetchAll(PDO::FETCH_ASSOC);

    echo json_encode(['status' => 'success', 'users' => $users, 'groups' => $groups]);
}

// دریافت پیام‌های یک چت خاص
if ($action == 'get_messages') {
    $targetId = $_GET['target_id'] ?? 0;
    $isGroup = $_GET['is_group'] ?? 0;

    if ($isGroup) {
        $stmt = $pdo->prepare("
            SELECT m.*, u.first_name, u.last_name, r.content as reply_content 
            FROM messages m 
            JOIN users u ON m.sender_id = u.id 
            LEFT JOIN messages r ON m.reply_to_id = r.id
            WHERE m.group_id = ? ORDER BY m.created_at ASC
        ");
        $stmt->execute([$targetId]);
    } else {
        // خوانده شدن پیام‌ها توسط من
        $pdo->prepare("UPDATE messages SET is_read = 1 WHERE sender_id = ? AND receiver_id = ? AND is_read = 0")->execute([$targetId, $userId]);

        $stmt = $pdo->prepare("
            SELECT m.*, r.content as reply_content, r.type as reply_type
            FROM messages m 
            LEFT JOIN messages r ON m.reply_to_id = r.id
            WHERE (m.sender_id = ? AND m.receiver_id = ?) OR (m.sender_id = ? AND m.receiver_id = ?) 
            ORDER BY m.created_at ASC
        ");
        $stmt->execute([$userId, $targetId, $targetId, $userId]);
    }
    
    $messages = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['status' => 'success', 'messages' => $messages, 'current_user_id' => $userId]);
}

// جستجوی کاربر
if ($action == 'search_user') {
    $query = $_POST['query'];
    $stmt = $pdo->prepare("SELECT id, first_name, last_name, phone, avatar FROM users WHERE phone LIKE ? OR username LIKE ?");
    $stmt->execute(["%$query%", "%$query%"]);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['status' => 'success', 'results' => $results]);
}

// ویرایش پیام
if ($action == 'edit_message') {
    $msgId = $_POST['msg_id'];
    $newContent = $_POST['content'];
    
    // چک کنیم پیام مال خود کاربر باشد
    $stmt = $pdo->prepare("UPDATE messages SET content = ?, is_edited = 1 WHERE id = ? AND sender_id = ?");
    $stmt->execute([$newContent, $msgId, $userId]);
    echo json_encode(['status' => 'success']);
}

// حذف پیام
if ($action == 'delete_message') {
    $msgId = $_POST['msg_id'];
    // سافت دیلیت (Soft Delete)
    $stmt = $pdo->prepare("UPDATE messages SET is_deleted = 1 WHERE id = ? AND sender_id = ?");
    $stmt->execute([$msgId, $userId]);
    echo json_encode(['status' => 'success']);
}

// تغییر پروفایل
if ($action == 'update_profile') {
    $fname = $_POST['first_name'];
    $lname = $_POST['last_name'];
    $uname = $_POST['username'];
    
    if (isset($_FILES['avatar']) && $_FILES['avatar']['error'] == 0) {
        $ext 'messages' => $messages, 'current_user_id' => $userId]);
}

// جستجوی کاربر
if ($action == 'search_user') {
    $query = $_POST['query'];
    $stmt = $pdo->prepare("SELECT id, first_name, last_name, phone, avatar FROM users WHERE phone LIKE ? OR username LIKE ?");
    $stmt->execute(["%$query%", "%$query%"]);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo json_encode(['status' => 'success', 'results' => $results]);
}

// ویرایش پیام
if ($action == 'edit_message') {
    $msgId = $_POST['msg_id'];
    $newContent = $_POST['content'];
    
    // چک کنیم پیام مال خود کاربر باشد
    $stmt = $pdo->prepare("UPDATE messages SET content = ?, is_edited = 1 WHERE id = ? AND sender_id = ?");
    $stmt->execute([$newContent, $msgId, $userId]);
    echo json_encode(['status' => 'success']);
}

// حذف پیام
if ($action == 'delete_message') {
    $msgId = $_POST['msg_id'];
    // سافت دیلیت (Soft Delete)
    $stmt = $pdo->prepare("UPDATE messages SET is_deleted = 1 WHERE id = ? AND sender_id = ?");
    $stmt->execute([$msgId, $userId]);
    echo json_encode(['status' => 'success']);
}

// تغییر پروفایل
if ($action == 'update_profile') {
    $fname = $_POST['first_name'];
    $lname = $_POST['last_name'];
    $uname = $_POST['username'];
    
    if (isset($_FILES['avatar']) && $_FILES['avatar']['error'] == 0) {
        $ext = pathinfo($_FILES['avatar']['name'], PATHINFO_EXTENSION);
        $newName = "avatar_$userId." . $ext;
        move_uploaded_file($_FILES['avatar']['tmp_name'], "uploads/$newName");
        $stmt = $pdo->prepare("UPDATE users SET avatar = ? WHERE id = ?");
        $stmt->execute([$newName, $userId]);
    }

    $stmt = $pdo->prepare("UPDATE users SET first_name=?, last_name=?, username=? WHERE id=?");
    $stmt->execute([$fname, $lname, $uname, $userId]);
    echo json_encode(['status' => 'success']);
}
?>
